/*---------------------------------------------------------------------------*\

    FILE....: FIFOC.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 2/10/97

    Functions used to implement First In First Out (FIFO) queues.  C
    callable version used in OpenSwitch12 kernel mode driver hda.c.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         V12PCI CT Card Software

         Copyright (C) David Rowe 2001 david@voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __FIFO__
#define __FIFO__

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK		0	// no problems 				
#define	FIFO_FULL	1	// FIFO full				
#define	FIFO_EMPTY	2	// FIFO empty				

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

void fifo_create(void **ppvfifo, int size);
void fifo_destroy(void *pvfifo);
int fifo_write(void *pvfifo, char *buf, int size);
int fifo_read(void *pvfifo, char *buf, int size);
void fifo_how_full(void *pvfifo, int *words);

// These functions must be linked in by caller.  This allows FIFO module
// to be eaily ported between user and kernel mode.
void *fifo_malloc(int size);
void fifo_free(void *mem);
void fifo_memcpy(char *dest, char *src, int length);

#endif	/// #ifndef __FIFO__ 

